var bitflags,amp_factor,cur_amp,tmp_sur,noise_surface,noise_buffer,noise_grid,cl,cv,n_sur2,map_maxsize;
bitflags=argument0
amp_factor=max(0,min(2,argument1));
cur_amp=max(0,min(2,argument2));
cur_size=1
noise_grid=ds_grid_create(map_dimx,map_dimy);
map_maxsize=power(2,map_size)
noise_surface=surface_create(map_maxsize,map_maxsize);
surface_set_target(noise_surface);
draw_clear(c_black);
surface_reset_target();
ds_grid_clear(noise_grid,0);
texture_set_interpolation(1);
for(n=1;n<max(map_dimx,map_dimy);n*=2)
{
    cur_size*=2;
    if(!(bitflags & n)) continue;
    tmp_sur=surface_create(cur_size,cur_size);
    surface_set_target(tmp_sur);
    for(i=0;i<cur_size;i++)
    {
        for(j=0;j<cur_size;j++)
        {
            draw_point_color(i,j,make_color_hsv(0,0,random(128*cur_amp)));
        }
    }
    surface_reset_target();
    surface_set_target(noise_surface);
    draw_set_blend_mode(bm_add);
    draw_surface_stretched(tmp_sur,0,0,map_maxsize,map_maxsize);
    draw_set_blend_mode(bm_normal);
    surface_reset_target();
    cur_amp*=amp_factor;
    surface_free(tmp_sur);
}
texture_set_interpolation(0);
n_sur2=surface_create(map_dimx,map_dimy);
surface_set_target(n_sur2);
draw_surface_part(noise_surface,(map_maxsize-map_dimx)/2,(map_maxsize-map_dimx)/2,map_dimx,map_dimy,0,0);
surface_reset_target();
surface_free(noise_surface);
noise_surface=n_sur2;
repeat(blobs_number)
    noise_add_blob(noise_surface,random_range(blobs_radius/2,blobs_radius),blobs_intensity,random(map_dimx),random(map_dimy));
noise_add_ring(noise_surface,ring_start,ring_end,ring_radius);
repeat(line_number)
    noise_add_line(noise_surface,line_width,line_intensity,random(map_dimx),random(map_dimy),random(map_dimx),random(map_dimy));
noise_add_fading_border(noise_surface,border_intensity,border_inner,border_outer);
noise_buffer=buffer_create(map_dimx*map_dimy*4,buffer_fixed,1);
buffer_get_surface(noise_buffer,noise_surface,0,0,0);
surface_free(noise_surface);
for(i=0;i<256;i++) noise_pdata[i]=0;
buffer_seek(noise_buffer,buffer_seek_start,0);
for(i=0;i<map_dimy;i++)      //inverted reading for compatibility issues with buffer_get_surface
{
    for(j=0;j<map_dimx;j++)
    {
        cl=buffer_read(noise_buffer,buffer_u32) & 255;
        noise_pdata[cl]++;
        noise_grid[# j,i]=cl;
    }
}
buffer_delete(noise_buffer);
noise_psum=0;
for(i=0;i<255;i++) noise_psum+=noise_pdata[i];
return noise_grid;
